/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ImmGRP1_EvIv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] eSourceValue = new byte[2];
    byte[] sourceValue2 = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte[] eDestinationRegister = new byte[2];
    byte[] oldDest = new byte[2];
    byte[] oldEDest = new byte[2];
    int intermediateResult = 0;
    int iCarryFlag = 0;
    byte[] tempResult = new byte[2];
    byte[] temp = new byte[2];

    public Instruction_ImmGRP1_EvIv() {
    }

    public Instruction_ImmGRP1_EvIv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.addressByte = this.cpu.getByteFromCode();
        this.sourceValue = new byte[2];
        this.sourceValue2 = new byte[2];
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.sourceValue = this.cpu.getWordFromCode();
        if (this.cpu.doubleWord) {
            this.eSourceValue = this.cpu.getWordFromCode();
        }
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    System.arraycopy(this.destinationRegister, 0, this.oldDest, 0, this.destinationRegister.length);
                    this.temp = Util.addWords(this.destinationRegister, this.sourceValue, 0);
                    System.arraycopy(this.temp, 0, this.destinationRegister, 0, this.temp.length);
                    this.cpu.flags[4] = Util.test_AF_ADD(this.oldDest[1], this.destinationRegister[1]);
                    this.cpu.flags[0] = Util.test_CF_ADD(this.oldDest, this.sourceValue, 0);
                    this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.sourceValue, this.destinationRegister, 0);
                    this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
                    this.cpu.flags[7] = this.destinationRegister[0] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.sourceValue2 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.temp = Util.addWords(this.sourceValue, this.sourceValue2, 0);
                System.arraycopy(this.temp, 0, this.tempResult, 0, this.temp.length);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[4] = Util.test_AF_ADD(this.sourceValue2[1], this.tempResult[1]);
                this.cpu.flags[0] = Util.test_CF_ADD(this.sourceValue2, this.sourceValue, 0);
                this.cpu.flags[11] = Util.test_OF_ADD(this.sourceValue2, this.sourceValue, this.tempResult, 0);
                this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
                break;
            }
            case 1: {
                this.cpu.flags[11] = false;
                this.cpu.flags[0] = false;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.destinationRegister[1] = (byte)(this.destinationRegister[1] | this.sourceValue[1]);
                    this.destinationRegister[0] = (byte)(this.destinationRegister[0] | this.sourceValue[0]);
                    this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
                    this.cpu.flags[7] = this.destinationRegister[0] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.sourceValue2 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.tempResult[1] = (byte)(this.sourceValue[1] | this.sourceValue2[1]);
                this.tempResult[0] = (byte)(this.sourceValue[0] | this.sourceValue2[0]);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
                break;
            }
            case 2: {
                this.iCarryFlag = (byte)(this.cpu.flags[0] ? 1 : 0);
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    System.arraycopy(this.destinationRegister, 0, this.oldDest, 0, this.destinationRegister.length);
                    byte[] byArray = Util.addWords(this.destinationRegister, this.sourceValue, this.iCarryFlag);
                    System.arraycopy(byArray, 0, this.destinationRegister, 0, byArray.length);
                    this.cpu.flags[4] = Util.test_AF_ADD(this.oldDest[1], this.destinationRegister[1]);
                    this.cpu.flags[0] = Util.test_CF_ADD(this.oldDest, this.sourceValue, this.iCarryFlag);
                    this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.sourceValue, this.destinationRegister, this.iCarryFlag);
                    this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
                    this.cpu.flags[7] = this.destinationRegister[0] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.sourceValue2 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.tempResult = Util.addWords(this.sourceValue, this.sourceValue2, this.iCarryFlag);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[4] = Util.test_AF_ADD(this.sourceValue2[1], this.tempResult[1]);
                this.cpu.flags[0] = Util.test_CF_ADD(this.sourceValue2, this.sourceValue, this.iCarryFlag);
                this.cpu.flags[11] = Util.test_OF_ADD(this.sourceValue2, this.sourceValue, this.tempResult, this.iCarryFlag);
                this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
                break;
            }
            case 3: {
                int n = this.iCarryFlag = this.cpu.flags[0] ? 1 : 0;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    System.arraycopy(this.destinationRegister, 0, this.oldDest, 0, this.destinationRegister.length);
                    this.temp = Util.subtractWords(this.destinationRegister, this.sourceValue, this.iCarryFlag);
                    System.arraycopy(this.temp, 0, this.destinationRegister, 0, this.temp.length);
                    this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest[1], this.destinationRegister[1]);
                    this.cpu.flags[0] = Util.test_CF_SUB(this.oldDest, this.sourceValue, 0);
                    this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.sourceValue, this.destinationRegister, 0);
                    this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
                    this.cpu.flags[7] = this.destinationRegister[0] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.sourceValue2 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.temp = Util.subtractWords(this.sourceValue2, this.sourceValue, this.iCarryFlag);
                System.arraycopy(this.temp, 0, this.tempResult, 0, this.temp.length);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[4] = Util.test_AF_SUB(this.sourceValue2[1], this.tempResult[1]);
                this.cpu.flags[0] = Util.test_CF_SUB(this.sourceValue2, this.sourceValue, 0);
                this.cpu.flags[11] = Util.test_OF_SUB(this.sourceValue2, this.sourceValue, this.tempResult, 0);
                this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
                break;
            }
            case 4: {
                this.cpu.flags[11] = false;
                this.cpu.flags[0] = false;
                this.cpu.flags[4] = false;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.destinationRegister[1] = (byte)(this.destinationRegister[1] & this.sourceValue[1]);
                    this.destinationRegister[0] = (byte)(this.destinationRegister[0] & this.sourceValue[0]);
                    this.cpu.flags[6] = this.destinationRegister[1] == 0 && this.destinationRegister[0] == 0;
                    this.cpu.flags[7] = this.destinationRegister[0] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                    if (!this.cpu.doubleWord) break;
                    this.eDestinationRegister = this.cpu.decodeExtraRegister(this.addressByte & 7);
                    this.eDestinationRegister[1] = (byte)(this.eDestinationRegister[1] & this.eSourceValue[1]);
                    this.eDestinationRegister[0] = (byte)(this.eDestinationRegister[0] & this.eSourceValue[0]);
                    this.cpu.flags[6] = this.cpu.flags[6] && this.eDestinationRegister[1] == 0 && this.eDestinationRegister[0] == 0;
                    this.cpu.flags[7] = this.eDestinationRegister[0] < 0;
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.tempResult = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.tempResult[1] = (byte)(this.tempResult[1] & this.sourceValue[1]);
                this.tempResult[0] = (byte)(this.tempResult[0] & this.sourceValue[0]);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[6] = this.tempResult[1] == 0 && this.tempResult[0] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
                if (!this.cpu.doubleWord) break;
                this.memoryReferenceLocation = Util.addWords(this.memoryReferenceLocation, new byte[]{0, 2}, 0);
                this.tempResult = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.tempResult[1] = (byte)(this.tempResult[1] & this.eSourceValue[1]);
                this.tempResult[0] = (byte)(this.tempResult[0] & this.eSourceValue[0]);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[6] = this.cpu.flags[6] && this.tempResult[1] == 0 && this.tempResult[0] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                break;
            }
            case 5: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    System.arraycopy(this.destinationRegister, 0, this.oldDest, 0, this.destinationRegister.length);
                    this.temp = Util.subtractWords(this.destinationRegister, this.sourceValue, 0);
                    System.arraycopy(this.temp, 0, this.destinationRegister, 0, this.temp.length);
                    this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest[1], this.destinationRegister[1]);
                    this.cpu.flags[0] = Util.test_CF_SUB(this.oldDest, this.sourceValue, 0);
                    this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.sourceValue, this.destinationRegister, 0);
                    this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
                    this.cpu.flags[7] = this.destinationRegister[0] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.sourceValue2 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.temp = Util.subtractWords(this.sourceValue2, this.sourceValue, 0);
                System.arraycopy(this.temp, 0, this.tempResult, 0, this.temp.length);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[4] = Util.test_AF_SUB(this.sourceValue2[1], this.tempResult[1]);
                this.cpu.flags[0] = Util.test_CF_SUB(this.sourceValue2, this.sourceValue, 0);
                this.cpu.flags[11] = Util.test_OF_SUB(this.sourceValue2, this.sourceValue, this.tempResult, 0);
                this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
                break;
            }
            case 6: {
                this.cpu.flags[11] = false;
                this.cpu.flags[0] = false;
                this.cpu.flags[4] = false;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.destinationRegister[1] = (byte)(this.destinationRegister[1] ^ this.sourceValue[1]);
                    this.destinationRegister[0] = (byte)(this.destinationRegister[0] ^ this.sourceValue[0]);
                    this.cpu.flags[6] = this.destinationRegister[1] == 0 && this.destinationRegister[0] == 0;
                    this.cpu.flags[7] = this.destinationRegister[0] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.tempResult = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.tempResult[1] = (byte)(this.tempResult[1] ^ this.sourceValue[1]);
                this.tempResult[0] = (byte)(this.tempResult[0] ^ this.sourceValue[0]);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[6] = this.tempResult[1] == 0 && this.tempResult[0] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
                break;
            }
            case 7: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue2 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue2 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.temp = Util.subtractWords(this.sourceValue2, this.sourceValue, 0);
                System.arraycopy(this.temp, 0, this.tempResult, 0, this.temp.length);
                this.cpu.flags[4] = Util.test_AF_SUB(this.sourceValue2[1], this.tempResult[1]);
                this.cpu.flags[0] = Util.test_CF_SUB(this.sourceValue2, this.sourceValue, 0);
                this.cpu.flags[11] = Util.test_OF_SUB(this.sourceValue2, this.sourceValue, this.tempResult, 0);
                this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
                break;
            }
            default: {
                throw new CPUInstructionException("Immediate Group 1 (0x81) instruction no case match.");
            }
        }
    }
}

